package kochModel;
import lrs.*;
import java.awt.*;

import kochModel.*;
//import kochModel.algos.*;
import fp.*;

/**
 * The non-base case state of the Koch curve.   This state is just a wrapper around a list of Koch curves that supplies the required
 * paint and grow methods.   These methods are recursively applied to the  list of Koch curves held.
 */
class InductState extends AKochState
{
  
  /**
   * The list of Koch curves.
   */
  private LRStruct<Koch> kochList = new LRStruct<Koch>();
  
  /**
   * Constructor for this state, not publicly accessible.
   * All this constructor does is to initialize the list of Kochs being held.
   * @param kochList A list of  Koch curves to attach as those being held.
   */
  InductState(LRStruct<Koch> kochList)  {
    
    this.kochList = kochList;
  }
  
  
  public <R, P> R execute(Koch host, IKochVisitor<R,P> algo, P...param) {
    return algo.inductCase(host, param);
  }
  
  public <R,P> R fold(final Koch host, final IFoldAlgo<Koch,R,P> algo, R base, final P... param) {
    return kochList.execute(new IAlgo<Koch,R,R> () {
      public R emptyCase(LRStruct<? extends Koch> host, R... rr) {
        return rr[0];
      }
      
      public R nonEmptyCase(LRStruct<? extends Koch> host, R... rr) {
        return algo.apply(host.getFirst(), host.getRest().execute(this,rr), param);
      }
      
    }, base);
  }  
}

